
 
; LED Flasher


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_ON & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT
	

;  RAM. Covers bank 0 & bank 1

EXTN			equ	H'20'	; Timer1 counter extension
LOOP			equ	H'21'	; loop for delay
; ******************************************************************

; start at memory 0

	org		0			; reset vector


MAIN

; calibrate internal oscillator
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'			; retlw 'xx'. xx is the osccal value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0


; set inputs/outputs
	clrf		GPIO		; outputs low
	movlw	B'00000100'	; comparator with reference 
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00000110'	; outputs/inputs set (GP1,GP2 an input)
	movwf	TRISIO		; port data direction register
	movlw	B'00001111'	; settings timer /128 and watchdog divider for 2.3s timeout
	movwf	OPTION_REG

	movlw	B'10001111'		;  0.25 + 15/32 Vdd reference for comparator
	movwf	VRCON
	
; analog inputs, A/D
	movlw	B'00000000'		;   
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
	movlw	B'00000000'	; port low
	movwf	GPIO	

	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on	

	bsf		GPIO,4			; LDR powered
	movlw	D'255'
	movwf	LOOP
DELAY1
	clrwdt
	decfsz	LOOP,f
	goto	DELAY1

; check GP2 (check LDR)
; no signal produced when GPIO,2 is low
	btfsc	GPIO,2
	goto	LED_FLSH
; 
; stop

DAY
	clrf		GPIO			; outputs low
; comparator and reference off
	movlw	B'00000111'		; comparator off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00101111'		; off (reference for comparator)
	movwf	VRCON
	bcf		STATUS,RP0	; select memory bank 0
	bcf		T1CON,0		; timer 1 off

; light
LIGHT
	bcf		GPIO,4			; LDR off
	clrwdt
	
	SLEEP
	nop						; awakes on watchdog
	bsf		GPIO,4			; drive LDR
	nop
	nop
	nop
	nop
; check if LDR is in light
; is GP2 low?
	btfss	GPIO,2	
	goto	LIGHT	
; comparator and reference on
	movlw	B'00000100'		; comparator with reference 
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'10001111'		; 0.25 + 15/32 Vdd reference for comparator
	movwf	VRCON
	bcf		STATUS,RP0	; bank 0


LED_FLSH

	movlw	B'00100000'
	movwf	GPIO		; GP5 high charge C1 via R1	
	nop
	nop
	nop
	nop
	nop
; timer start

	bcf		T1CON,0		; timer 1 off
	clrf		TMR1L
	clrf		TMR1H
	clrf		EXTN
	bsf		T1CON,0		; timer 1 on

; compare GP1 input with reference	
READ
	btfss	PIR1,TMR1IF
	goto	COMPARE
	bcf		PIR1,TMR1IF
	incf		EXTN,f
	clrwdt
COMPARE
	btfsc	CMCON,COUT	; if comparator output is low then GP1 input is greater than reference
	goto	READ

; record timer1 values and EXTN

	bcf		T1CON,0		; timer 1 off

; check if >65.536ms for mode setting
	movlw	D'01'
	subwf	EXTN,w		; if >1 run flash
	btfsc	STATUS,C
	goto	LED_FLASH

	clrf		GPIO		; GPIO,5,4,0 low
; take timer1L Timer1H from 0
; place in timer 1
	comf	TMR1H,f
	comf	TMR1L,f

	movlw	B'00010001'
	movwf	GPIO		; GP0 high discharge C1 via R2 to drive LED

; complement EXTN
	comf 	EXTN,f

; start timer1
	bsf		T1CON,0		; timer 1 on

	
; wait for Timer1 overflow flag, increase EXTN
; when EXTN overflows, then end of timeout 	

	bcf		PIR1,TMR1IF

OVER
	bsf		GPIO,4
	btfss	PIR1,TMR1IF
	goto	OVER
	bcf		PIR1,TMR1IF
	clrwdt
	incfsz	EXTN,f
	goto	OVER
	btfss	GPIO,2		; is LDR on (in light)
	goto	DAY

	clrf		GPIO		; GPIO,5,4,0 low	
	goto	LED_FLSH
	
LED_FLASH
; LED on for 65ms

	movlw	B'00010001'
	movwf	GPIO		; GP0 high discharge C1 via R2 to drive LED
; clear timer 1
	clrf		TMR1H
	clrf		TMR1L
; load EXTN
;	movlw	H'FE'		 ; extension gives longer period
;	movwf 	EXTN

; start timer1
	bsf		T1CON,0		; timer 1 on
	
; wait for Timer1 overflow flag, increase EXTN
; when EXTN overflows, then end of timeout 	

	bcf		PIR1,TMR1IF

OVER1
	bsf		GPIO,4
	btfss	PIR1,TMR1IF
	goto	OVER1
	bcf		PIR1,TMR1IF
	clrwdt
;	incfsz	EXTN,f
;	goto	OVER1
	btfss	GPIO,2		; is LDR on (in light)
	goto	DAY

	clrf		GPIO		; GPIO,5,4,0 low	
	goto	LED_FLSH
	
; ***************************************************************************	

; Subroutines




	end
